<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class DropCap extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "dropcap";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[dropcap]D[/dropcap]\n[dropcap color=\"#fff\" bg=\"#000\" radius=\"cicle\"]D[/dropcap]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/		
	var $sample_attributes = array(
		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin color"
		),
		array(
			"name"		=> "bg",
			"hint"		=> "#hexcode, default: skin color"
		),
		array(
			"name"		=> "border",
			"hint"		=> "#hexcode, default: skin color"
		),

		array(
			"name"		=> "bold",
			"hint"		=> "yes|no, default: no"
		),

		array(
			"name"		=> "radius",
			"hint"		=> "round|corners|none, default:none"
		),
		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization"
		)	
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$css	= array();
		$style	= array();
		$vars	= $data["vars"];

		if ($vars["border"]) {
			$css["custom"] = "dropcap-set-border";
			$style[] = $this->getBackground($vars["border"] , "border-color")["bg_style"];
		}

		if ($vars["bg"]) {
			$css["custom"] = "dropcap-set-bg";
			$style[] = $this->getBackground($vars["bg"] , "background")["bg_style"];
		}

		if ($vars["color"]) {
			$style[] = $this->getBackground($vars["color"] , "color")["bg_style"];
		}

		if ($vars["radius"]) {
			switch ($vars["radius"]) {
				case "round":	
					$css["custom"] = "dropcap-set-border";
					$css[] = "dropcap-set-border-round"; 
				break;
				case "corners": 
					$css["custom"] = "dropcap-set-border";
					$css[] = "dropcap-set-border-radius"; 
				break;
			}
		} 
		
		if ($vars["bold"] == "yes") {
			$css[] = "dropcap-set-bold";
		}
		

		if ($vars["class"]) { $css[] = $vars["class"]; }

		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main",
				array(
					"css"		=> implode(" " , $css),
					"style"		=> implode(" " , $style),
					"content"	=> $vars["content"],
				)
			),
			"before"	=> "",
			"after"		=> "",
		);
	}
	
}